//
//  MCTableView+ArrayController.h
//  MCApplication
//
//  Created by Ali Lalani on 9/6/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCTableView.h"

@interface MCTableView (ArrayController)
- (void)bindToArrayController:(NSArrayController *)ac groupIdentifier:(NSString *)groupID subsetIdentifier:(NSString *)sID;
- (IBAction)activateColumnManager:(id)sender;
@end

@interface MCTableView (ArrayControllerPrivate)


- (NSString*)_columnAutoSaveName;

- (NSFormatter*)_formatterForConfig: (NSDictionary*)formatter_config;
- (NSMutableDictionary*)_columnConfigWithGroupDict: (NSDictionary*)groupDict andSubsetDict: (NSDictionary*)subsetDict;

- (void)_createColumnLookupWithColumnConfigs: (NSArray*)column_configs andVisibleList: (NSArray*)visible_list;

- (void)_loadColumnConfigs;

- (void)_removeNibColumns;

- (void)_syncUserDefaultsToColumnConfig;
- (void)_syncColumnConfigToUserDefaults;

- (NSTableColumn*)_columnForConfig: (NSMutableDictionary*)config;
- (void)_populateColumnsFromConfigAndBindToArrayController: (NSArrayController*)ac;
@end
